
ALTER FUNCTION [dbo].[CF_Cbte_Descrip](@Id_Trans INT)
RETURNS VARCHAR(100)	
AS

BEGIN


DECLARE @Descripcion	VARCHAR(100);
DECLARE @Id_Tipo_Cbte	CHAR(4);
DECLARE @id_sucursal	SMALLINT;
DECLARE @id_sucursal_Compra 	SMALLINT;
DECLARE @Compromete_Compras SMALLINT;
DECLARE @Letra			VARCHAR(3);
DECLARE @Descrip_Corta	CHAR(4);

DECLARE @sucursal_char	VARCHAR(5);
DECLARE @Comprobante_Nro INT;
DECLARE @comprobante_nro_char VARCHAR(9);

/*
SET @Id_Tipo_Cbte = ISNULL((SELECT Id_Tipo_Cbte FROM Cbtes WHERE Id_Trans = @Id_Trans),'')
SET @Descrip_Corta	= ISNULL((SELECT RTRIM(LTRIM(Descrip_Corta)) FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte),' ');
SET @Letra			= ISNULL((SELECT RTRIM(LTRIM(Letra)) FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte),' ');
SET @id_sucursal	= (SELECT id_Sucursal FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte);
*/

SELECT @Id_Tipo_Cbte = ISNULL(C.Id_Tipo_Cbte,'')
     , @Descrip_Corta = ISNULL(RTRIM(LTRIM(T.Descrip_Corta)),'')
	 , @Letra = ISNULL(RTRIM(LTRIM(Letra)) ,'')
	 , @id_sucursal = ISNULL(t.Id_Sucursal,0)
	 , @id_sucursal_Compra = ISNULL(C.Id_Sucursal,0)
	 , @Compromete_Compras = ISNULL(T.Compromete_Compras,0)
FROM Cbtes C, Cbtes_Tipos T
WHERE C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
AND C.Id_Trans = @Id_Trans

IF @Compromete_Compras != 0
   SET @id_sucursal	= @id_sucursal_Compra;
ELSE
   SET @id_sucursal	= ISNULL((SELECT Sucursal_Nro FROM Empresas_Suc WHERE Id_Sucursal = @id_sucursal),0);
   
   
SET @sucursal_char	= (SELECT RIGHT('00000'+CAST(@id_sucursal AS VARCHAR(5)), 5));
SET @comprobante_nro = ISNULL((SELECT Comprobante_Nro FROM Cbtes WHERE Id_Trans = @Id_Trans),0)
SET @comprobante_nro_char = (SELECT RIGHT('00000000'+CAST(@comprobante_nro AS VARCHAR(9)), 8));

SET @Descripcion = (@Descrip_Corta+' '+@Letra+' '+@sucursal_char+'-'+@comprobante_nro_char);

RETURN @Descripcion;

END
       
          